// DIOsimpleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DIOsimple.h"
#include "DIOsimpleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDIOsimpleDlg dialog

CDIOsimpleDlg::CDIOsimpleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDIOsimpleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDIOsimpleDlg)
	m_value = 0;
	m_channel = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDIOsimpleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDIOsimpleDlg)
	DDX_Text(pDX, IDC_EDIT1, m_value);
	DDX_Text(pDX, IDC_EDIT2, m_channel);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDIOsimpleDlg, CDialog)
	//{{AFX_MSG_MAP(CDIOsimpleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDIOsimpleDlg message handlers

BOOL CDIOsimpleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_DriverInstance = OpenDriverLINX(m_hWnd,"*.dll"); //Open DriverLINX dialog for the driver
	m_pSR = (DL_ServiceRequest*) new DL_ServiceRequest;//allocate memory for the service request
	m_LogicalDevice=0; //Set the Logical Device number here
	memset(m_pSR,0,sizeof(DL_ServiceRequest));//reset the members of the service request to defaults
	DL_SetServiceRequestSize(*m_pSR);
	m_pSR->device=m_LogicalDevice;
	m_pSR->operation=INITIALIZE;
	m_pSR->mode=OTHER;
	m_pSR->subsystem=DEVICE;
	m_pSR->hWnd=m_hWnd;
	DriverLINX(m_pSR);
	showMessage(m_pSR); //Show DriverLINX errors, if any
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDIOsimpleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDIOsimpleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDIOsimpleDlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
	if(m_DriverInstance != NULL)  //Close the DriverLINX driver, if it is open
	{
		CloseDriverLINX(m_DriverInstance);
		m_DriverInstance=NULL;
	}
	if(m_pSR != NULL) //Free the memory used by the service request
	{
		delete m_pSR;
		m_pSR=NULL;
	}
	OnOK(); //Quit the dialog.
}

void CDIOsimpleDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
}

void CDIOsimpleDlg::OnButton2() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE); //Get the values from the text boxes
	memset(m_pSR,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_pSR);
	m_pSR->hWnd=m_hWnd;
	m_pSR->device=m_LogicalDevice;
	m_pSR->operation=START;
	m_pSR->subsystem=DI;
	m_pSR->mode=POLLED;
	m_pSR->channels.nChannels=1;
	m_pSR->channels.chanGain[0].channel=m_channel;
	m_pSR->status.typeStatus=IOVALUE;
	DriverLINX(m_pSR); //Execute the service request
	showMessage(m_pSR); //and show the result
	m_value=m_pSR->status.u.ioValue; //set the value field the value read
	UpdateData(FALSE); //Update the textbox
}

void CDIOsimpleDlg::OnButton3() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);  //Get the current textbox values
	memset(m_pSR,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_pSR);
	m_pSR->hWnd=m_hWnd;
	m_pSR->device=m_LogicalDevice;
	m_pSR->operation=START;
	m_pSR->subsystem=DO;
	m_pSR->mode=POLLED;
	m_pSR->channels.nChannels=1;
	m_pSR->channels.chanGain[0].channel=m_channel;
	m_pSR->status.typeStatus=IOVALUE;
	m_pSR->status.u.ioValue=m_value; //Set the i/o value to the textbox value
	DriverLINX(m_pSR);
	showMessage(m_pSR);
}
